﻿param([string]$name, [string]$dest)

$script:name = $name
$script:dest = $dest

$chrome = "${env:ProgramFiles}\Google\Chrome\Application\chrome.exe"
$msedge = "${env:ProgramFiles(x86)}\Microsoft\Edge\Application\msedge.exe"

function error_exit($msg) { 
    write-host -foregroundcolor red $msg', 按任一键退出'
    $null = $host.ui.rawui.readkey('NoEcho,IncludeKeyDown')
    exit 1
}
function exit_if_error($msg) { 
    if ($? -ne $true) { error_exit $msg }
}

#安装chrome浏览器
function install_chrome() {
    #下载
    $pkg_chrome = "googlechromestandaloneenterprise64.msi"
    if (-not (test-path $pkg_chrome)) {
        write-host -foregroundcolor yellow "下载chrome浏览器..."
            cmd /c curl -k https://felixzone.com/topwar/$pkg_chrome -o $pkg_chrome -f --progress-bar
            exit_if_error "无法下载chrome浏览器"
    }

    #安装
    write-host -foregroundcolor yellow "安装chrome浏览器..."
    start-process msiexec.exe -args "/i $pwd\$pkg_chrome /quiet" -verb runas -window hidden
    for($i = 0; -not (test-path $chrome) -and $i -lt 60; $i++) {start-sleep 1}
    if ($i -eq 60) { cmd /c exit 1 }
    exit_if_error "无法安装chrome浏览器"

    #清理
    remove-item $pkg_chrome
}

#安装口袋助手插件
function install_plugin() {
    #下载
    write-host -foregroundcolor yellow "下载口袋助手插件..."
    cmd /c curl -k https://felixzone.com/topwar/plugin.zip -o plugin.zip -f --progress-bar
    exit_if_error "无法下载口袋助手插件"

    #安装
    write-host -foregroundcolor yellow "安装口袋助手插件..."
    expand-archive plugin.zip -dest plugin
    exit_if_error "无法安装口袋助手插件"

    #清理
    remove-item plugin.zip
}

#设置快捷名称
if (-not $script:name) {
    $script:name = read-host "输入快捷名称（推荐使用游戏昵称, 默认名为口袋奇兵）"
    if (-not $script:name) { $script:name = "口袋奇兵" }
}

#设置快捷方式位置
if (-not $script:dest) {
    while ($true) {
        $script:dest = read-host "输入快捷方式位置（默认为桌面）"
        if (-not $script:dest) { $script:dest = [System.Environment]::GetFolderPath("Desktop") }
        if (test-path $script:dest) { break }
        write-host -ForegroundColor red "位置不存在, 请重新输入"
    }
    $script:dest = $(Resolve-Path $script:dest).path
}

#确定快捷方式全路径名
$script:link = "$script:dest\$script:name.lnk"
if (test-path $script:link) {
    $overwrite = read-host "快捷方式已存在, 是否覆盖（Y覆盖, 其他退出, 默认退出）?"
    if ( $overwrite -ne 'Y') { exit 1}  
}

#设置游戏浏览器
if (test-path $chrome) { $script:browser = $chrome }
if (test-path $msedge) { $script:browser = $msedge }
if (-not $script:browser) { install_chrome; $script:browser = $chrome }

#设置插件目录
if (-not (test-path plugin)) { install_plugin }
if (-not ((test-path plugin\topwar.ico) -and (test-path plugin\manifest.json) -and (select-string -path plugin\manifest.json -pattern "口袋助手" -quiet))) { error_exit "没有找到口袋助手插件" }
$script:extension = $(Resolve-Path plugin).path

#设置用户数据目录
if ($script:browser.contains('chrome')) { $dir = "$HOME\AppData\Local\Google\Chrome\" }
if ($script:browser.contains('msedge')) { $dir = "$HOME\AppData\Local\Microsoft\Edge\" }
$script:user_data_dir = $dir + $script:name

#创建快捷方式
$arg_app = "--app=https://warh5.rivergame.net/webgame/index.html"
$arg_user_data_dir = "--user-data-dir=$script:user_data_dir"
$arg_load_extension = "--load-extension=$script:extension"
$shell = New-Object -ComObject WScript.Shell
$shortcut = $shell.CreateShortcut($script:link) 
$shortcut.TargetPath = $script:browser  # 设置快捷方式目标程序
$shortcut.Arguments = "$arg_app $arg_load_extension $arg_user_data_dir --disable-background-timer-throttling --window-size=1280,800"  # 设置快捷方式参数
$shortcut.WorkingDirectory = $pwd.path  # 设置“起始位置”属性，即工作目录
$shortcut.WindowStyle = 0 
$shortcut.IconLocation = "$script:extension\topwar.ico,0"  # 快捷方式图标
$shortcut.Save()
exit_if_error "无法创建快捷方式"

#添加站点白名单
if ($script:browser.contains('msedge')) {
    reg query HKLM\SOFTWARE\Policies\Microsoft\Edge\SleepingTabsBlockedForUrls /d /f https://warh5.rivergame.net/ >$null 2>&1
    if ( $? -ne $true ) {
        $maxAttempts = 100
        for ($i = 1; $i -le $maxAttempts -and $?; $i++) { 
              reg query HKLM\SOFTWARE\Policies\Microsoft\Edge\SleepingTabsBlockedForUrls /v $i 1>$null 2>&1
         }
        $proc = start-process reg.exe -args "add HKLM\SOFTWARE\Policies\Microsoft\Edge\SleepingTabsBlockedForUrls /v $i /t reg_sz /d https://warh5.rivergame.net/ /f" -verb runas -window hidden -passthru -wait
        if ($proc.exitcode -ne 0) { error_exit "无法添加游戏站点白名单" }
    }
}